///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

HBRUSH BGColor = CreateSolidBrush( RGB(212, 208, 200) );

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define IDM_Settings   1000
#define IDM_ViewLog    1001
#define IDM_Backup     1002
#define IDM_Restore    1003
#define IDM_MaintSched 1004
#define IDM_HoldSched  1005
#define IDM_ViewSched  1006
#define IDM_Help       1007
#define IDM_Close      1008

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define ID_MYTOOLBAR   2000

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define BTIcons        9
#define TBButtons      12
#define TBLength       36
#define TBWidth        36

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

TBBUTTON tbb[] = {
    {0, IDM_Settings, 0, TBSTYLE_BUTTON, 0, 0},
    {1, IDM_ViewLog, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0},

    {0, 0, 0, TBSTYLE_SEP, 0, 0},

    {2, IDM_Backup, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0},
    {3, IDM_Restore, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0},

    {0, 0, 0, TBSTYLE_SEP, 0, 0},

    {4, IDM_MaintSched, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0},
    {8, IDM_HoldSched, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0},
    {5, IDM_ViewSched, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0},

    {0, 0, 0, TBSTYLE_SEP, 0, 0},

    {6, IDM_Help, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0},
    {7, IDM_Close, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0}
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

HWND CreateToolBar(HWND hWnd)
{
    HWND hTool     = NULL;
    HBITMAP BitMap = NULL;

    InitCommonControls();

    if(! (BitMap = LoadBitmap(MainInstance, MAKEINTRESOURCE(ToolBarBitmap) )) )
        ErrorMessage(hWnd, "Failed to load bitmap");

    hTool = CreateToolbarEx(
        hWnd,
        WS_CHILD | WS_VISIBLE |TBSTYLE_TOOLTIPS|TBSTYLE_FLAT|TBSTYLE_TOOLTIPS,
        ID_MYTOOLBAR,
        BTIcons,
        NULL,
        (DWORD)BitMap,
        tbb,
        0,
        TBLength, TBWidth,
        TBLength, TBWidth,
        sizeof(TBBUTTON)
    );

    tbb[0].iString  = SendMessage(hTool,(UINT)TB_ADDSTRING,(WPARAM)0,(LPARAM) "Configure");
    tbb[1].iString  = SendMessage(hTool,(UINT)TB_ADDSTRING,(WPARAM)0,(LPARAM) "View Log");

    tbb[3].iString  = SendMessage(hTool,(UINT)TB_ADDSTRING,(WPARAM)0,(LPARAM) "Backup");
    tbb[4].iString  = SendMessage(hTool,(UINT)TB_ADDSTRING,(WPARAM)0,(LPARAM) "Restore");

    tbb[6].iString  = SendMessage(hTool,(UINT)TB_ADDSTRING,(WPARAM)0,(LPARAM) "Manage Jobs");
    tbb[7].iString  = SendMessage(hTool,(UINT)TB_ADDSTRING,(WPARAM)0,(LPARAM) "Halt Jobs");
    tbb[8].iString  = SendMessage(hTool,(UINT)TB_ADDSTRING,(WPARAM)0,(LPARAM) "View Jobs");

    tbb[10].iString = SendMessage(hTool,(UINT)TB_ADDSTRING,(WPARAM)0,(LPARAM) "Help");
    tbb[11].iString = SendMessage(hTool,(UINT)TB_ADDSTRING,(WPARAM)0,(LPARAM) "Close");

    SendMessage(hTool, TB_ADDBUTTONS, TBButtons, (LONG)&tbb);
    SendMessage(hTool, TB_AUTOSIZE, 0, 0);

    return hTool;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK JobManagerDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

    static HMENU SystemMenu   = NULL;
    static HMENU DialogMenu   = NULL;
    static HWND  MainToolBar  = NULL;

    //--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG) // Received A Initilize Dialog Message
    {
        JobManagerDialog_hWnd = xHandle;

        SystemMenu = GetSystemMenu(JobManagerDialog_hWnd, FALSE);
        AppendMenu(SystemMenu, MF_SEPARATOR, 0, 0);
        AppendMenu(SystemMenu, MF_STRING, 1000, "About");
        AppendMenu(SystemMenu, MF_STRING, 1001, "Version");
        AppendMenu(SystemMenu, MF_SEPARATOR, 0, 0);
        AppendMenu(SystemMenu, MF_STRING, 1002, "www.NetWorkDLS.com");

        SendMessage(JobManagerDialog_hWnd, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)TitleCaption);
        SendMessage(JobManagerDialog_hWnd, WM_SETICON, TRUE, (LPARAM)LoadIcon(MainInstance, MAKEINTRESOURCE(DialogIcon)) );

        DialogMenu = LoadMenu(MainInstance, MAKEINTRESOURCE(JobManagerMenu));
        SetMenu(JobManagerDialog_hWnd, DialogMenu);

        MainToolBar = CreateToolBar(JobManagerDialog_hWnd);

        StatusListBox_hWnd = GetDlgItem(JobManagerDialog_hWnd, 1000);

        if(AllOnHold == TRUE)
        {
            SendMessage(MainToolBar, (UINT)TB_CHECKBUTTON, (WPARAM)IDM_HoldSched, (LPARAM)MAKELONG (TRUE, 0));
            ModifyMenu(DialogMenu, 30003, MF_BYCOMMAND+MF_UNCHECKED, 30003, "All jobs on hold");
        }

        if(AllOnHold == FALSE)
        {
            SendMessage(MainToolBar, (UINT)TB_CHECKBUTTON, (WPARAM)IDM_HoldSched, (LPARAM)MAKELONG (FALSE, 0));
            ModifyMenu(DialogMenu, 30003, MF_BYCOMMAND+MF_CHECKED, 30003, "All jobs active");
        }
/*
        if(!IsRegistered)
        {
            int DaysLeft = DaysLeftInTrial();

            if(IsExpired)
                sprintf(RegistrationText, "The SQLBackup trial has expired.");
            else sprintf(RegistrationText, "This is a trial version of SQLBackup. You have %d days remaining.", DaysLeft);

            DialogBox(MainInstance, MAKEINTRESOURCE(TimeToRegister), JobManagerDialog_hWnd, TimeToRegisterDialog);
        }
*/
        LoadJobHistory(StatusListBox_hWnd);

        RECT ThisRect;
        GetClientRect(JobManagerDialog_hWnd, &ThisRect);
        MoveWindow(StatusListBox_hWnd, 0, 70, ThisRect.right, ThisRect.bottom - 70, TRUE);

        CenterWindow(JobManagerDialog_hWnd);

        StartupComplete = TRUE;

        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CTLCOLORDLG)
        return (LONG)BGColor;

    //--------------------------------------------------------------------------

    if((HANDLE)lParam == StatusListBox_hWnd)
        return Set_Color( RGB(0,0,100), RGB(255,255,255), wParam);

    //--------------------------------------------------------------------------

    if(xMessage == WM_SIZE ) // Received A Message
    {
        int nWidth = LOWORD(lParam);
        int nHeight = HIWORD(lParam);
        MoveWindow(StatusListBox_hWnd, 0, 70, nWidth, nHeight - 70, TRUE);
        SendMessage(MainToolBar, TB_AUTOSIZE, 0, 0);
        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_COMMAND) // Received A Message
    {
        if(wParam == IDM_Settings || wParam == ID_FILE_CONFIGURE) //- Options (Dialog Menu Command)
        {
            if( IsWinNT() )
            {
                DialogBox(MainInstance, MAKEINTRESOURCE(wNTOptions), JobManagerDialog_hWnd, wNTOptionsDialog);
            }
            else{
                DialogBox(MainInstance, MAKEINTRESOURCE(w9xOptions), JobManagerDialog_hWnd, w9xOptionsDialog);
            }

            return 0;
        }

        if(wParam == IDM_ViewLog || wParam == ID_FILE_VIEWJOBLOG) //- Job log (Dialog Menu Command)
        {
            DialogBox(MainInstance, MAKEINTRESOURCE(ViewLog), JobManagerDialog_hWnd, ViewLogDialog);
            return 0;
        }

        if(wParam == IDM_Close || wParam == ID_FILE_CLOSEDAILOG) //- Close (Dialog Menu Command)
        {
            EndDialog(JobManagerDialog_hWnd,0);
            return 0;
        }

        if(wParam == IDM_Backup || wParam == ID_OPERATION_MANUALBACKUP) //- Manual Backup (Dialog Menu Command)
        {
            if(CurrentlyRunning == TRUE)
            {
                MessageBox(JobManagerDialog_hWnd, "Please wait untill the current process has completed.", TitleCaption, MB_TASKMODAL);
                return 0;
            }

        	DialogBox(MainInstance, MAKEINTRESOURCE(ManBackup), JobManagerDialog_hWnd, ManBackupDialog);
            return 0;
        }
        if(wParam == IDM_Restore || wParam == ID_OPERATION_MANUALRESTORE) //- Manual Restore (Dialog Menu Command)
        {
            if(CurrentlyRunning == TRUE)
            {
                MessageBox(JobManagerDialog_hWnd, "Please wait untill the current process has completed.", TitleCaption, MB_TASKMODAL);
                return 0;
            }

        	DialogBox(MainInstance, MAKEINTRESOURCE(ManRestore), JobManagerDialog_hWnd, ManRestoreDialog);
            return 0;
        }

        if(wParam == IDM_MaintSched || wParam == ID_SCHEDULE_MANAGEJOBS) //- Maintain Schedule (Dialog Menu Command)
        {
            if(CurrentlyRunning == TRUE)
            {
                MessageBox(JobManagerDialog_hWnd, "Please wait untill the current process has completed.", TitleCaption, MB_TASKMODAL);
                return 0;
            }

            if(AllOnHold == TRUE)
            {
                DialogBox(MainInstance, MAKEINTRESOURCE(MaintainSchedule), JobManagerDialog_hWnd, ScheduleDialog);
            }
            else{
                AllOnHold = TRUE;
                DialogBox(MainInstance, MAKEINTRESOURCE(MaintainSchedule), JobManagerDialog_hWnd, ScheduleDialog);
                AllOnHold = FALSE;
            }
            return 0;
        }

        if(wParam == IDM_ViewSched || wParam == ID_SCHEDULE_VIEWJOBS) //- View Schedule (Dialog Menu Command)
        {
            DialogBox(MainInstance, MAKEINTRESOURCE(ViewSchedule), JobManagerDialog_hWnd, ViewScheduleDialog);

            return 0;
        }

        if(wParam == IDM_HoldSched || wParam == ID_SCHEDULE_HOLDSCHEDULE) //- On Hold (Dialog Menu Command)
        {
            if(AllOnHold == TRUE)
            {
                ModifyMenu(DialogMenu, 30003, MF_BYCOMMAND+MF_CHECKED, 30003, "All jobs active");
                SendMessage(MainToolBar, (UINT)TB_CHECKBUTTON, (WPARAM)IDM_HoldSched, (LPARAM)MAKELONG (FALSE, 0));
                AllOnHold = FALSE;
                return 0;
            }

            if(AllOnHold == FALSE)
            {
                ModifyMenu(DialogMenu, 30003, MF_BYCOMMAND+MF_UNCHECKED, 30003, "All jobs on hold");
                SendMessage(MainToolBar, (UINT)TB_CHECKBUTTON, (WPARAM)IDM_HoldSched, (LPARAM)MAKELONG (TRUE, 0));
                AllOnHold = TRUE;
                return 0;
            }

            return 0;
        }

        if( wParam == ID_HELP_ABOUT) //- About (Dialog Menu Command)
        {
            NetLogo(JobManagerDialog_hWnd);
            return 0;
        }

        if(wParam == ID_HELP_ENTERREGISTRATIONCODE) //- Enter Registration Code (Dialog Menu Command)
        {
//          DialogBox(MainInstance, MAKEINTRESOURCE(Registration), JobManagerDialog_hWnd, RegistrationDialog);
            return 0;
        }

        if(wParam == ID_SPECIAL_RECALCULATESCHEDULES) //- ReCalculate (Dialog Menu Command)
        {
            CalculateSchedules();
            MessageBox(JobManagerDialog_hWnd, "All schedules have been recalculated.", TitleCaption, MB_TASKMODAL);
            return 0;
        }

        if(wParam == IDM_Help || wParam == ID_HELP_HELPCONTENTS) //- Help contents (Dialog Menu Command)
        {
//          ShellExecute(JobManagerDialog_hWnd, "open", "hh.exe", "its:C:\\448Delta.chm::/Known%20Bugs.Html", "C:\\", SW_SHOWNORMAL);
            ShellExecute(JobManagerDialog_hWnd, "open", HelpPath, "", "C:\\", SW_SHOWNORMAL);
            return 0;
        }

        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_SYSCOMMAND) // Received A System Menu Message
    {
        if(LOWORD(wParam) == 1000) //- About (SysMenu Command)
        {
            NetLogo(JobManagerDialog_hWnd);
            return 0;
        }

        if(LOWORD(wParam) == 1001) //- Version (SysMenu Command)
        {
            char VersionText[128];
            sprintf(VersionText, "%s, Version %s", TitleCaption, FileVersion);
            MessageBox(JobManagerDialog_hWnd, VersionText, "Application Version", MB_TASKMODAL);
            return 0;
        }

        if(LOWORD(wParam) == 1002) //- www.NetWorkDLS.com (SysMenu Command)
        {
            ShellExecute(0,"Open", "Http://www.NetWorkDLS.com", NULL, NULL, SW_SHOWNORMAL);
            return 0;
        }

        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE)  // Received Close Message
    {
        EndDialog(JobManagerDialog_hWnd, 0);
        return 0;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_DESTROY) // Received Destroy Message
    {
//        PostQuitMessage(0);
        return 0;
    }

    //--------------------------------------------------------------------------

    return 0;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

